// A konvtri mveleteket megvalst
// fablak modulja

unit KonyvtarU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, GlobalU, Printers;

type
  TfrmKonyvtar = class(TForm)
    StringGrid1: TStringGrid;
    Konyvfelvitel: TButton;
    BetoltesFajlbol: TButton;
    Mentesfajlba: TButton;
    Nyomtatas: TButton;
    Kilepes: TButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Konyvtorles: TButton;
    btnModositas: TButton;
    procedure FormCreate(Sender: TObject);
    procedure KonyvfelvitelClick(Sender: TObject);
    procedure BetoltesFajlbolClick(Sender: TObject);
    procedure KilepesClick(Sender: TObject);
    procedure MentesfajlbaClick(Sender: TObject);
    procedure StringGrid1SetEditText(Sender: TObject; ACol, ARow: Integer;
      const Value: String);
    procedure KonyvtorlesClick(Sender: TObject);
    procedure NyomtatasClick(Sender: TObject);
    procedure btnModositasClick(Sender: TObject);
    procedure StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
  private
    procedure KonyvSorba(const Konyv:TKonyv; rw:integer);
    procedure SorKonyvbe(rw:integer; var Konyv:TKonyv);
  public
    procedure UpdateTable;
  end;

var
  frmKonyvtar: TfrmKonyvtar;

implementation

uses KonyvU;

{$R *.DFM}

// A knyv beillesztse a tblba
procedure TfrmKonyvtar.KonyvSorba(const Konyv:TKonyv; rw : integer);
begin
  with Stringgrid1 do
   begin
    GlobalU.Konyv.sorszam:=Konyv.sorszam;
    cells[0,rw]:=inttostr(Konyv.sorszam);
    cells[1,rw]:=Konyv.szerzo;
    cells[2,rw]:=Konyv.cim;
    cells[3,rw]:=dateTostr(Konyv.beszerezve);
    cells[4,rw]:=format('%6.0f Ft',[Konyv.ar]);
   end;
end;

// A tblzat egy sornak adatait a globlis
// konyv vltozban troljuk
procedure TfrmKonyvtar.SorKonyvbe(rw : integer; var Konyv:TKonyv);
var sv:string;
begin
  with Stringgrid1 do
   begin
      Konyv.sorszam:=strToInt(cells[0,rw]);
      Konyv.szerzo:=cells[1,rw];
      Konyv.cim:=cells[2,rw];
      Konyv.beszerezve:=strToDate(cells[3,rw]);
      sv:=cells[4,rw];
      delete(sv,length(sv)-1,2);
      Konyv.ar:=strToFloat(sv);
   end;
end;


// Knyv hozzadsa a tblhoz (az utols sorba)
procedure TfrmKonyvtar.UpdateTable;
var
   aktsor:integer;
begin
    with stringgrid1 do
     case Muvelet of
        Felvitel:
          begin
            aktsor:=rowcount;
            rowcount:=rowcount+1;
            fixedrows:=1;
            KonyvSorba(Globalu.Konyv, aktsor);
          end;
        Modositas:
          begin
            KonyvSorba(Globalu.Konyv, Stringgrid1.row);
          end;
      end;
end;

// A form ltrehozsakor kialaktjuk a tblt
procedure TfrmKonyvtar.FormCreate(Sender: TObject);
begin
    with stringgrid1 do
        begin
          fixedcols:=1;
          fixedrows:=1;
          rowcount:=1;
          colcount:=5;
          cells[0,0]:='No';
          cells[1,0]:='Szerz';
          cells[2,0]:='Knyvcm';
          cells[3,0]:='Vsrolva';
          cells[4,0]:='r';
          colwidths[0]:=25;
          colwidths[1]:=150;
          colwidths[2]:=150;
          colwidths[3]:=80;
          colwidths[4]:=50;
     end;

     with Konyv do
      begin
         sorszam:=1;
         szerzo:='Borland Int.';
         cim:='Delphi 5 Developers guide';
         beszerezve:=encodedate(2000,02,23);
         ar := 21900;
      end;
      Muvelet:=Felvitel;
      UpdateTable;
end;


// j knyv felvitele
procedure TfrmKonyvtar.KonyvfelvitelClick(Sender: TObject);
begin
  Muvelet:=Felvitel;
  inc(Konyv.sorszam);
  Konyv.szerzo:='';
  Konyv.cim:='';
  Konyv.beszerezve:=date;
  Konyv.ar:=0;
  frmKonyv.showmodal;
end;

// Knyvek betltse LIB llomnybl
procedure TfrmKonyvtar.BetoltesFajlbolClick(Sender: TObject);
var
  f    : file of TKonyv;
  Konyv : TKonyv;
  i    : integer;
begin
  if Opendialog1.Execute then
    begin
      try
        assignfile(f, Opendialog1.Filename);
        reset(f);
        Stringgrid1.Rowcount:=Filesize(f)+1;
        Stringgrid1.fixedrows:=1;
        for i:=1 to Stringgrid1.Rowcount-1 do
           begin
             read(f,Konyv);
             KonyvSorba(Konyv,i);
           end;
        Stringgrid1.Row:=1;
        Stringgrid1.Col:=1;
        closefile(f);
        Mentett:=true;
      except
        ShowMessage('llomnyolvassi hiba!')
      end;
    end;
end;

// Kilps, ha szksge felajnlja a mentst
procedure TfrmKonyvtar.KilepesClick(Sender: TObject);
begin
  if not Mentett then MentesFajlbaClick(Sender);
  frmKonyvtar.close;
end;

// A tblzatban trolt knyveket LIB fjlba mentjk
procedure TfrmKonyvtar.MentesfajlbaClick(Sender: TObject);
var
  f    : file of TKonyv;
  Konyv : TKonyv;
  i    : integer;
begin
  if Savedialog1.Execute then
    begin
      try
        assignfile(f, Savedialog1.Filename);
        rewrite(f);
        try
            for i:=1 to Stringgrid1.Rowcount-1 do
               begin
                 SorKonyvbe(i,Konyv);
                 write(f,Konyv);
               end;
         finally
            closefile(f);
         end;
      except
        ShowMessage('File write error!')
      end;
    end;
end;

// Ha valamit megvltoztatunk a tblzatban, szksges lesz
// a ments
procedure TfrmKonyvtar.StringGrid1SetEditText(Sender: TObject; ACol,
  ARow: Integer; const Value: String);
begin
  Mentett:=false;
end;

// Knyv trlse
procedure TfrmKonyvtar.KonyvtorlesClick(Sender: TObject);
var i:integer;
begin
   if stringgrid1.row=0 then
    begin
      beep;
      exit;
    end;
   with stringgrid1 do
     for i:=row to rowcount-1 do
       rows[i]:=rows[i+1];
   stringgrid1.rowcount:=stringgrid1.rowcount-1;
   if stringgrid1.row=0 then Konyv.sorszam:=0;
end;

// A tblzat egyszer eszkzzel trtn nyomtatsa
procedure TfrmKonyvtar.NyomtatasClick(Sender: TObject);
var f  : TextFile;
    i,j: integer;
begin
   AssignPrn(f);
   Rewrite(f);
   with Stringgrid1 do
    for i:=0 to RowCount-1 do
      begin
        writeln(f);
        writeln(f);
        for j:=0 to 4 do
           write(f,cells[j,i],#9);
      end;
    closefile(f);
end;

// A Knyvbejegyzs mdostsa
procedure TfrmKonyvtar.btnModositasClick(Sender: TObject);
begin
   if Stringgrid1.row=0 then exit;
   Muvelet:=Modositas;
   SorKonyvbe(stringgrid1.row, Globalu.Konyv);
   frmKonyv.showmodal;
end;

// A kivlasztott s a fkuszlt cella tsznezse
procedure TfrmKonyvtar.StringGrid1DrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
begin
   with Stringgrid1 do
    begin
      if (gdselected in state) or (gdfocused in state) then
       begin
        canvas.pen.color:=clGreen;
        canvas.brush.color:=clYellow;
        canvas.font.color:=clred;
        canvas.Rectangle(rect.left,rect.top,rect.Right, rect.bottom);
        canvas.TextOut(Rect.left+2, Rect.top+2,Cells[Acol,Arow]);
       end;
    end;
end;

end.
